from tabular_data import Table
class ShoppingCart:
    def __init__(self):
        self._products=set()
    def __call__(self,product):
        self._products.add(product)
    def clear(self):
        self._products=set()
    def __str__(self):
        t=Table(['Product Name', 'Product Price'],\
                    [p.name for p in self._products],\
                    [p.price for p in self._products])
        total=sum([p._price for p in self._products])
        return str(t)+'\n'+'Total: '+str(total) #put the total on new line

    #Container protocol
    def __contains__(self,name):
        return name in [p.name for p in self._products]

    #Size protocol
    def __len__(self):
        return len(self._products)

    #Iteration protocol
    def __iter__(self):
        return iter(self._products)
        
